{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{pstd}
{cmd:dsimih graph} {hline 2} Plot dynamic simulation results after {cmd:svarih}


{marker syntax}{...}
{title:Syntax}

{p 8 15 2}
{cmd:dsimih} {cmdab:g:raph} [{it:{help dsimih_graph##stat:stat}}] [{help using} {it:filename}] [{cmd:,} {it:{help dsimih_graph##options_table:options}}]

{marker stat}{...}
{p2colset 5 16 18 2}{...}
{p2col:{it:stat}}Description{p_end}
{p2line}
{p2col:{cmdab:si:rf}}structural impulse-response function{p_end}
{p2col:{cmdab:sf:evd}}structural forecast-error variance decomposition{p_end}
{p2line}
{p2colreset}{...}

{p 4 6 2}You may specify only one {it:stat}.

{marker options_table}{...}
{synoptset 29 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Graph Data}
{synopt:{opt reg:imes(rgmlist)}}plot results for regimes {it:rgmlist}; default: all regimes available in the {cmd:dsimih} results{p_end}
{synopt:{opt i:mpulse(impvars)}}use shock(s) of equation(s) {it:impvars} as impulse variables{p_end}
{synopt:{opt r:esponse(respvars)}}use {it:respvars} as response variable(s){p_end}
{synopt:{opt noci}}suppress confidence intervals{p_end}
{synopt:{opt set:ype(string)}}plot confidence intervals based on standard errors of type {it:setype}; default: asymptotic{p_end}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt lst:ep(#)}}use # for first step{p_end}
{synopt:{opt ust:ep(#)}}use # for maximum step{p_end}

{syntab:Graph Rendition}
{synopt:{opt byo:rder(irorder)}}display subgraphs by {it:irorder}{p_end}
{synopt:{cmdab:pl:otopts(}{it:{help cline_options}}{cmd:)}}affect rendition of lines plotting {it:stat}{p_end}
{synopt:{cmdab:ciop:ts(}{it:{help area_options}}{cmd:)}}affect rendition of the confidence intervals for {it:stat}{p_end}
{synopt:{opth byop:ts(by_option)}}all suboptions allowed by the {help by_option}{p_end}
{synopt:{it:twoway_options}}any options other than {opt by()} documented in {manhelpi twoway_options G-3}{p_end}

{syntab:Data Set}
{synopt:{opt n:umber(#)}}access results number {it:#} ; only allowed if the {cmd:using} modifier refers to a {cmd:.ster} file{p_end}
{synopt:{opt k:eep}}keep the Stata data set underlying the graph created{p_end}
{synopt:{opt clear}}specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{opt dsimih graph} plots dynamic simulation results created by {help dsimih create}.
Options {opt keep} and {opt clear} allow you to keep the results in Stata data set memory.
If you omit these options, results are only displayed in the results window.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{dlgtab:Graph Data}

{phang}
{opt reg:imes(rgmlist)} is a {help numlist} and specifies the volatility regimes for which results are displayed.
By default, graphs for all regimes that are present in the {cmd:dsimih} results are created.
{it:rgmlist} must be a subset of the list of regimes that occur in the estimation sample.

{phang}
{opt i:mpulse(impars)} specifies the impulse variables for which the statistics are to be reported.
If {opt impulse()} is not specified, each model variable, in turn, is used.
{it:impvars} may be specified in any way allowed by a standard Stata {help varlist}.
{it:varlist} here does not refer to the variables in memory but to the variables recorded in e(depvar).

{phang}
{opt r:esponse(respvars)} specifies the response variables for which the statistics are to be reported.
If {opt response()} is not specified, each endogenous variable, in turn, is used.
{it:respvars} may be specified in any way allowed by a standard Stata {help varlist}.
{it:varlist} here does not refer to the variables in memory but to the variables recorded in e(depvar).

{phang}
{opt noci} suppresses reporting of the confidence intervals for {it:stat}.

{phang}
{opt set:ype(selist)} specifies the standard errors type based on which confidence bands are drawn.
{it:setype} may contain one of the tokens {opt a:symptotic}, {opt bs} and {opt bsp}.
They stand for asymptotic standard errors, standard errors from a residual bootstrap, and standard errors from a parametric bootstrap based on draws from the normal distribution, respectively.
The default are asymptotic standard errors.

{phang}
{opt l:evel(#)} specifies the confidence level, as a percentage, for confidence intervals, when they are reported.
The default is {cmd:level(95)} or as set by {helpb set level}.

{phang}
{opt lstep(#)} specifies the first step, or period, to be included in the graphs. {cmd:lstep(0)} is the default.

{phang}
{opt ustep(#)}, {it:#} {ul:>} 0, specifies the maximum step, or period, to be included in the graphs.

{dlgtab:Graph Rendition}

{phang}
{opt byo:rder(irorder)} specifies the order of the subgraphs by {it:impvar} and {it:respvar} within the combined graph.
{opt byorder()} may contain tokens {opt i:mpulse} and/or {opt r:esponse}.
Combinations allowed are {cmd:byorder(i)}, {cmd:byorder(r)}, {cmd:byorder(i r)}, and {cmd:byorder(r i)}, where {cmd:byorder(i)} is equivalent to {cmd:byorder(i r)}, and {cmd:byorder(r)} is equivalent to {cmd:byorder(r i)}.

{phang}
{opt pl:otopts(cline_options)} affect the rendition of the plotted statistics (the {it:stat}).
{it:cline_options} are as described in {manhelpi cline_options G-3}.

{phang}
{opt ciop:ts(area_options)} affect the rendition of the confidence intervals for {it:stat}.
{it:area_options} are as described in {manhelpi area_options G-3}.

{phang}
{opt byop:ts(by_option)} may contain all suboptions of {manhelpi by_option G-3}.
{opt byopts()} affects how the subgraphs are combined, labeled, etc.

{phang}
{it:twoway_options} are any of the options documented in {manhelpi twoway_options G-3}, excluding {opt by()}.
These include options for titling the graph (see {manhelpi title_options G-3}) and for saving the graph to disk (see {manhelpi saving_option G-3}).


{dlgtab:Data Set}

{phang}
{opt k:eep} Option {opt k:eep} keeps the data set underlying the graph display in memory and does not restore the memory state that was in place before {cmd:dsimih graph} was invoked.
{cmd:dsimih graph} uses {help dsimih table} which uses {help dsimih use} to load a data set with dynamic simulation results into memory and then draws the graph.
The data set that option {opt keep} keeps in memory corresponds exactly to the output graph displayed by {cmd:dsimih graph}.

{pmore}
This option is useful if you want to format the graph in a way that {cmd:dsimih graph} does not support.
Option {opt keep} gives you the data set underlying the graphical output of {cmd:dsimih graph}.
You can then apply your own graphics commands to the data.{p_end}

{phang}
{opt clear} specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk.
This option is for usage in conjunction with option {opt keep}.


{marker remarks}{...}
{title:Remarks}

{pstd}
{cmd:dsimih graph} by default accesses DS results in {cmd:e()} but is also capable of accessing DS results stored in files using its {opt using} modifier.
For details on how the {opt using} modifier works in all {cmd:dsimih} subcommands, see {help dsimih_etodta##theusingmodifier:dsimih etodta}.


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bfa_unconstr , ereplace:. svarih examples bfa_unconstr , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create , step(8):. dsimih create , step(8)}{p_end}

{pstd}
By default, {cmd:dsimih graph} will make a combined table of all combinations of impulse and response variables, for all regimes:

{phang2}{stata dsimih graph sirf , name(dsimih_gr1, replace):. dsimih graph sirf , name(dsimih_gr1, replace)}{p_end}

{pstd}
A tailored grayscale graph, making exensive use of minimum option abbreviations:

{phang2}{stata dsimih gr si, reg(1) i(*inv) sch(s2mono) pl(lw(thick)) ciop(lp(dash) lw(thick) fc(none)) byop(c(1) yr) yli(0):. dsimih gr si, reg(1) i(*inv) sch(s2mono) pl(lw(thick)) ciop(lp(dash) lw(thick) fc(none)) byop(c(1) yr) yli(0)}{p_end}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
{cmd:dsimih graph} was inspired in many ways by official Stata's {help irf graph}.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih table},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}


